/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.minecraft.class_768;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainerMenu;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleScreen<CONTAINER extends MultiModuleContainerMenu<?>>
extends class_465<CONTAINER> {
    protected List<ModuleScreen<?, ?>> modules = Lists.newArrayList();
    public int cornerX;
    public int cornerY;
    public int realWidth = -1;
    public int realHeight = -1;

    public MultiModuleScreen(CONTAINER container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
    }

    protected void addModule(ModuleScreen<?, ?> module) {
        this.modules.add(module);
    }

    public List<class_768> getModuleAreas() {
        ArrayList<class_768> areas = new ArrayList<class_768>(this.modules.size());
        for (ModuleScreen<?, ?> module : this.modules) {
            areas.add(module.getArea());
        }
        return areas;
    }

    protected void method_25426() {
        if (this.realWidth > -1) {
            this.field_2792 = this.realWidth;
            this.field_2779 = this.realHeight;
        }
        super.method_25426();
        this.cornerX = this.field_2776;
        this.cornerY = this.field_2800;
        this.realWidth = this.field_2792;
        this.realHeight = this.field_2779;
        assert (this.field_22787 != null);
        for (ModuleScreen<?, ?> module : this.modules) {
            this.updateSubmodule(module);
        }
        for (ModuleScreen<?, ?> module : this.modules) {
            module.method_25423(this.field_22787, this.field_22789, this.field_22790);
            this.updateSubmodule(module);
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        for (ModuleScreen<?, ?> module : this.modules) {
            module.handleDrawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        this.drawContainerName(guiGraphics);
        this.drawPlayerInventoryName(guiGraphics);
        for (ModuleScreen<?, ?> module : this.modules) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(module.field_2776 - this.field_2776), (float)(module.field_2800 - this.field_2800), 0.0f);
            module.handleDrawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
            guiGraphics.method_51448().method_22909();
        }
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.handleRenderHoveredTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void drawBackground(class_332 guiGraphics, class_2960 background) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(background, this.cornerX, this.cornerY, 0, 0, this.realWidth, this.realHeight);
    }

    protected void drawContainerName(class_332 guiGraphics) {
        guiGraphics.method_51430(this.field_22793, this.method_25440().method_30937(), 8, 6, 0x404040, false);
    }

    protected void drawPlayerInventoryName(class_332 guiGraphics) {
        assert (class_310.method_1551().field_1724 != null);
        class_2561 localizedName = class_310.method_1551().field_1724.method_31548().method_5476();
        guiGraphics.method_51430(this.field_22793, localizedName.method_30937(), 8, this.field_2779 - 96 + 2, 0x404040, false);
    }

    public void method_25410(class_310 mc, int width, int height) {
        super.method_25410(mc, width, height);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.method_25410(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        int oldX = this.field_2776;
        int oldY = this.field_2800;
        int oldW = this.field_2792;
        int oldH = this.field_2779;
        this.field_2776 = this.cornerX;
        this.field_2800 = this.cornerY;
        this.field_2792 = this.realWidth;
        this.field_2779 = this.realHeight;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
        this.field_2776 = oldX;
        this.field_2800 = oldY;
        this.field_2792 = oldW;
        this.field_2779 = oldH;
    }

    protected boolean method_2378(int left, int top, int right, int bottom, double pointX, double pointY) {
        return (pointX -= (double)this.cornerX) >= (double)(left - 1) && pointX < (double)(left + right + 1) && (pointY -= (double)this.cornerY) >= (double)(top - 1) && pointY < (double)(top + bottom + 1);
    }

    protected void updateSubmodule(ModuleScreen<?, ?> module) {
        module.updatePosition(this.cornerX, this.cornerY, this.realWidth, this.realHeight);
        if (module.field_2776 < this.field_2776) {
            this.field_2792 += this.field_2776 - module.field_2776;
            this.field_2776 = module.field_2776;
        }
        if (module.field_2800 < this.field_2800) {
            this.field_2779 += this.field_2800 - module.field_2800;
            this.field_2800 = module.field_2800;
        }
        if (module.guiRight() > this.field_2776 + this.field_2792) {
            this.field_2792 = module.guiRight() - this.field_2776;
        }
        if (module.guiBottom() > this.field_2800 + this.field_2779) {
            this.field_2779 = module.guiBottom() - this.field_2800;
        }
    }

    public void method_2385(class_332 guiGraphics, class_1735 slotIn) {
        ModuleScreen<?, ?> module = this.getModuleForSlot(slotIn.field_7874);
        if (module != null) {
            class_1735 slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return;
            }
        }
        if (slotIn instanceof WrapperSlot) {
            slotIn.field_7873 = ((WrapperSlot)slotIn).parent.field_7873;
            slotIn.field_7872 = ((WrapperSlot)slotIn).parent.field_7872;
        }
        super.method_2385(guiGraphics, slotIn);
    }

    public boolean method_2387(class_1735 slotIn, double mouseX, double mouseY) {
        ModuleScreen<?, ?> module = this.getModuleForSlot(slotIn.field_7874);
        if (module != null) {
            class_1735 slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return false;
            }
        }
        return super.method_2387(slotIn, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.method_25403(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForPoint(double x, double y) {
        for (ModuleScreen<?, ?> module : this.modules) {
            if (!this.method_2378(module.field_2776, module.field_2800, module.guiRight(), module.guiBottom(), x + (double)this.cornerX, y + (double)this.cornerY)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForSlot(int slotNumber) {
        return this.getModuleForContainer(((MultiModuleContainerMenu)((Object)this.getMenu())).getSlotContainer(slotNumber));
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForContainer(class_1703 container) {
        for (ModuleScreen<?, ?> module : this.modules) {
            if (module.method_17577() != container) continue;
            return module;
        }
        return null;
    }

    public CONTAINER getMenu() {
        return (CONTAINER)((Object)((MultiModuleContainerMenu)this.field_2797));
    }
}

